/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ScanOnServerMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final Optional<BlockPos> anchorPos;
    private final String name;
    private final boolean saveEntities;

    public ScanOnServerMessage(FriendlyByteBuf buf) {
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.saveEntities = buf.readBoolean();
        this.anchorPos = buf.readBoolean() ? Optional.of(buf.m_130135_()) : Optional.empty();
    }

    public ScanOnServerMessage(BlockPos from, BlockPos to, String name, boolean saveEntities, Optional<BlockPos> anchorPos) {
        this.from = from;
        this.to = to;
        this.name = name;
        this.saveEntities = saveEntities;
        this.anchorPos = anchorPos;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.writeBoolean(this.saveEntities);
        buf.writeBoolean(this.anchorPos.isPresent());
        this.anchorPos.ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130064_(arg_0));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ItemScanTool.saveStructure(ctxIn.getSender().m_20193_(), this.from, this.to, (Player)ctxIn.getSender(), this.name, this.saveEntities, this.anchorPos);
    }
}

